@extends('layouts.app')

@section('title', '419 Page Expired')

@section('content')
<div class="error-container">
    <div class="error-image">
        <svg xmlns="http://www.w3.org/2000/svg" class="feather feather-clock" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
            <circle cx="12" cy="12" r="10" fill="rgba(255,255,255,0.1)" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></circle>
            <polyline points="12 6 12 12 16 14" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></polyline>
        </svg>
    </div>
    
    <h1 class="error-code">419</h1>
    <h2 class="error-title">Page Expired</h2>
    
    <p class="error-message">
        Your session has expired. Please refresh the page and try again.
    </p>
    
    <div class="error-actions">
        <a href="{{ url()->previous() }}" class="btn btn-primary">Go Back</a>
        <a href="{{ url('/') }}" class="btn btn-secondary">Home</a>
    </div>
</div>
@endsection
